﻿using System.Windows;
using System.Windows.Controls;

namespace CodeUiElements
{
    // Listing 20-3. Tworzenie elementów interfejsu użytkownika w kodzie ukrytym
    public partial class MainPage : UserControl
    {
        private Button myButton;
        private TextBlock messageText;
        public MainPage()
        {
            InitializeComponent();
            myButton = new Button
            {
                HorizontalAlignment = HorizontalAlignment.Center,
                VerticalAlignment = VerticalAlignment.Top,
                FontSize = 20,
                Content = "Kliknij mnie!"
            };
            myButton.Click += new RoutedEventHandler(myButton_Click);
            messageText = new TextBlock
            {
                Text = "Tu będzie wyświetlany komunikat",
                TextWrapping = TextWrapping.Wrap,
                TextAlignment = TextAlignment.Center,
                FontSize = 30,
                FontWeight = FontWeights.Bold,
                HorizontalAlignment = HorizontalAlignment.Center,
                VerticalAlignment = VerticalAlignment.Center
            };
            LayoutRoot.Children.Add(myButton);
            LayoutRoot.Children.Add(messageText);
        }

        void myButton_Click(object sender, RoutedEventArgs e)
        {
            messageText.Text = "Witaj, świecie!";
        }
    }
}
